#include "PhysXTriangleMeshWrapper.h"
#include "CoordinateMapping.h"
#include <NxTriangleMeshShape.h>
#include <NxTriangleMesh.h>
#include <NxTriangleMeshDesc.h>
#include <NxMat34.h>

cPhysXTriangleMeshWrapper::cPhysXTriangleMeshWrapper(const NxTriangleMeshShape& shape, const cCoordinateMapping& coordinateMapping, float scale)
{
    NxMat34 transform = shape.getGlobalPose();
    transform.M *= scale;
    transform.t *= scale;
    const NxTriangleMesh& mesh = shape.getTriangleMesh();
    NxTriangleMeshDesc meshDesc;
    mesh.saveToDesc(meshDesc);
    const char* bytePtr;
    int32_t i;
    _pointCoords.reserve(meshDesc.numVertices * 3);
    bytePtr = (const char*)(meshDesc.points);
    for(i = 0; i != static_cast<int32_t>(meshDesc.numVertices); ++i)
    {
        const NxVec3* data = (const NxVec3*)bytePtr;        
        NxVec3 transformed;
        transform.multiply(*data, transformed);
        _pointCoords.push_back(static_cast<int32_t>(transformed.x));
        _pointCoords.push_back(static_cast<int32_t>(transformed.y));
        _pointCoords.push_back(static_cast<int32_t>(transformed.z));
        bytePtr += meshDesc.pointStrideBytes;
    }
    for(i = 0; i != static_cast<int32_t>(meshDesc.numVertices); ++i)
    {
        coordinateMapping.applyTo(&_pointCoords[i * 3]);
    }
    _vertexIndices.reserve(meshDesc.numTriangles * 3);
    bytePtr = (const char*)(meshDesc.triangles);
    if(meshDesc.flags & NX_MF_16_BIT_INDICES)
    {
        for(i = 0; i != static_cast<int32_t>(meshDesc.numTriangles); ++i)
        {
            const NxU16* data = (const NxU16*)bytePtr;
            _vertexIndices.push_back(static_cast<int32_t>(data[0]));
            _vertexIndices.push_back(static_cast<int32_t>(data[2])); // reverses winding order
            _vertexIndices.push_back(static_cast<int32_t>(data[1]));
            bytePtr += meshDesc.triangleStrideBytes;
        }
    }
    else
    {
        for(i = 0; i != static_cast<int32_t>(meshDesc.numTriangles); ++i)
        {
            const NxU32* data = (const NxU32*)bytePtr;
            _vertexIndices.push_back(static_cast<int32_t>(data[0]));
            _vertexIndices.push_back(static_cast<int32_t>(data[2])); // reverses winding order
            _vertexIndices.push_back(static_cast<int32_t>(data[1]));
            bytePtr += meshDesc.triangleStrideBytes;
        }
    }
}

// iFaceVertex interface
int32_t
cPhysXTriangleMeshWrapper::faces() const
{
    return static_cast<int32_t>(_vertexIndices.size() / 3);
}
int32_t
cPhysXTriangleMeshWrapper::vertices() const
{
    return static_cast<int32_t>(_pointCoords.size() / 3);
}
int32_t
cPhysXTriangleMeshWrapper::vertexIndex(int32_t face, int32_t vertexInFace) const
{
    return _vertexIndices[face * 3 + vertexInFace];
}
int32_t
cPhysXTriangleMeshWrapper::vertexX(int32_t vertex) const
{
    return _pointCoords[vertex * 3 + 0];
}
int32_t
cPhysXTriangleMeshWrapper::vertexY(int32_t vertex) const
{
    return _pointCoords[vertex * 3 + 1];
}
float
cPhysXTriangleMeshWrapper::vertexZ(int32_t vertex) const
{
    return static_cast<float>(_pointCoords[vertex * 3 + 2]);
}
int32_t
cPhysXTriangleMeshWrapper::faceAttribute(int32_t face, int32_t attributeIndex) const
{
    return -1;
}
